/**
 * Copyright (C)2004 dGIC Corporation.
 *
 * This file is part of djUnit plugin.
 *
 * djUnit plugin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * djUnit plugin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with djUnit plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */
package com.jcoverage.coverage;

import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoverageUtil;
import jp.co.dgic.testing.common.AbstractBcelModifier;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;

import org.apache.bcel.classfile.JavaClass;


public class BcelCoverageInstrumenter extends AbstractBcelModifier {

	private Instrument inst;

	public BcelCoverageInstrumenter() {
		super("Coverage");
		inst = new Instrument();
	}

	protected byte[] modify(JavaClass jc) throws Exception {
		return instrument(jc);
	}

	private byte[] instrument(JavaClass jc) {

		String className = jc.getClassName();

		if (!CoverageUtil.isUseCoverage()) {
			return null;
		}

		if (!CoverageUtil.isIncluded(className)) {
			return null;
		}

		if (CoverageUtil.isExcluded(className)) {
			return null;
		}

		InternalMockObjectManager.printConsole("[instrument] " + className);

		if (inst.isInterface(jc) || inst.isAlreadyInstrumented(jc)) {
			InternalMockObjectManager.printConsole(className + " is isInterface or isAlreadyInstrumented.");
			return jc.getBytes();
		}

		InstrumentClassGen instrument =
			new InstrumentClassGen(jc, inst.ignoreRegex);
		instrument.addInstrumentation();

		InstrumentationInternal i =
			(InstrumentationInternal) InstrumentationFactory
				.getInstance()
				.newInstrumentation(jc.getClassName());

		if (instrument.getSourceLineNumbers().isEmpty()) {
			System.out.println(
				"no source line numbers found for: "
					+ jc.getClassName()
					+ ", compile with debug=\"yes\".");
		}

		i.setSourceLineNumbers(instrument.getSourceLineNumbers());
		i.setSourceFileName(jc.getSourceFileName());
		i.setSourceLineNumbersByMethod(instrument.getMethodLineNumbers());
		i.setConditionalsByMethod(instrument.getMethodConditionals());
		i.setMethodNamesAndSignatures(
			instrument.getMethodNamesAndSignatures());

		return instrument.getClassGen().getJavaClass().getBytes();
	}

}
