/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock.asm;

import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.asm.AsmClassChecker;
import jp.co.dgic.testing.common.virtualmock.asm.AsmConstractorVisitor;
import jp.co.dgic.testing.common.virtualmock.asm.AsmMethodVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class AsmClassVisitor
extends ClassWriter {
    protected AsmClassChecker acc;
    protected String className;

    public AsmClassVisitor(AsmClassChecker acc) {
        super(1);
        this.acc = acc;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        InternalMockObjectManager.printConsole("[modify class] " + name + " " + signature);
        InternalMockObjectManager.printConsole("[class version] " + version);
        this.className = name.replace('/', '.');
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isStatic = false;
        if ((access & 8) > 0) {
            isStatic = true;
        }
        InternalMockObjectManager.printConsole("#################################################################");
        InternalMockObjectManager.printConsole("#################################################################");
        InternalMockObjectManager.printConsole("### " + access + (isStatic ? " static " : " ") + name + " " + signature);
        InternalMockObjectManager.printConsole("#################################################################");
        InternalMockObjectManager.printConsole("#################################################################");
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x400) > 0) {
            return mv;
        }
        if ((access & 0x100) > 0) {
            return mv;
        }
        int maxLocals = this.acc.getMaxLocals(name, desc);
        return this.createMethodVisitor(mv, name, desc, signature, isStatic, exceptions, maxLocals);
    }

    protected MethodVisitor createMethodVisitor(MethodVisitor mv, String name, String desc, String signature, boolean isStatic, String[] exceptions, int maxLocals) {
        if ("<init>".equalsIgnoreCase(name)) {
            return new AsmConstractorVisitor(mv, this.className, name, desc, signature, exceptions, maxLocals, this.acc.getSuperClassNames());
        }
        return new AsmMethodVisitor(mv, this.className, name, desc, signature, isStatic, exceptions, maxLocals, this.acc.getSuperClassNames());
    }
}

