/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock.asm;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jp.co.dgic.testing.common.virtualmock.asm.AsmEmptyVisitor;
import jp.co.dgic.testing.common.virtualmock.asm.AsmMethodChecker;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class AsmClassChecker
extends ClassAdapter {
    private static final String JUNIT_TEST_INTERFACENAME = "junit.framework.Test";
    private static final String JUNIT4_TESTRUNNER_ANNOTATION = "org/junit/runner";
    private String _className;
    private String _superClassName;
    private String[] _interfaces;
    private HashMap _maxLocals = new HashMap();
    private HashMap _exceptionsMap = new HashMap();
    private Set _methodNames = new HashSet();
    private boolean isInterface = false;
    private boolean hasJUnit4TestAnnotation = false;
    private AsmClassChecker _superClassChecker;

    public AsmClassChecker() {
        super((ClassVisitor)new AsmEmptyVisitor());
    }

    public String getClassName() {
        return this._className;
    }

    public String getSuperClassName() {
        return this._superClassName;
    }

    public AsmClassChecker getSuperClassChecker() {
        return this._superClassChecker;
    }

    public void setSuperClassChecker(AsmClassChecker superClassChecker) {
        this._superClassChecker = superClassChecker;
    }

    public String[] getInterfaces() {
        return this._interfaces;
    }

    public String[] getSuperClassNames() {
        Set names = this.getAllSuperClassNames();
        return names.toArray(new String[names.size()]);
    }

    public Set getAllSuperClassNames() {
        Set<String> names = null;
        if (this._superClassChecker == null) {
            names = new HashSet();
            if (this._superClassName != null) {
                names.add(this._superClassName);
            }
        } else {
            names = this._superClassChecker.getAllSuperClassNames();
        }
        names.add(this._className);
        return names;
    }

    public boolean isTestCase() {
        if (this.hasJUnit4TestAnnotation) {
            return true;
        }
        boolean isTestCase = this.hasTestInterface(this._interfaces);
        if (isTestCase || this._superClassChecker == null) {
            return isTestCase;
        }
        return this._superClassChecker.isTestCase();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean hasJUnit4TestAnnotation() {
        return this.hasJUnit4TestAnnotation;
    }

    public void setJUnit4TestAnnotation(boolean hasAnnotation) {
        this.hasJUnit4TestAnnotation = hasAnnotation;
    }

    public void putMaxLocals(String methodName, String desc, int maxLocal) {
        this._maxLocals.put(String.valueOf(methodName) + desc, new Integer(maxLocal));
    }

    public int getMaxLocals(String methodName, String desc) {
        try {
            Integer max = (Integer)this._maxLocals.get(String.valueOf(methodName) + desc);
            if (max == null) {
            }
            return max;
        }
        finally {
            return -1;
        }
    }

    public void putExceptions(String methodNameAndDesc, String[] exceptions) {
        if (exceptions == null || exceptions.length == 0) {
            return;
        }
        this._exceptionsMap.put(methodNameAndDesc, exceptions);
    }

    public String[] getExceptions(String methodName, String desc) {
        String key = String.valueOf(methodName) + desc;
        String[] exceptions = this.getExceptions(key);
        if (exceptions == null) {
            return new String[0];
        }
        return exceptions;
    }

    public String[] getExceptions(String methodNameAndDesc) {
        if (this._exceptionsMap.containsKey(methodNameAndDesc)) {
            return (String[])this._exceptionsMap.get(methodNameAndDesc);
        }
        if (this._superClassChecker == null) {
            return null;
        }
        return this._superClassChecker.getExceptions(methodNameAndDesc);
    }

    public void putMethodName(String methodNameAndDesc) {
        this._methodNames.add(methodNameAndDesc);
    }

    public String getOwnerName(String methodNameAndDesc, String oldOwner) {
        if (this._methodNames.contains(methodNameAndDesc)) {
            return this._className;
        }
        if (this._superClassChecker == null) {
            return oldOwner;
        }
        return this._superClassChecker.getOwnerName(methodNameAndDesc, oldOwner);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String key = String.valueOf(name) + desc;
        this.putExceptions(key, exceptions);
        this.putMethodName(key);
        return new AsmMethodChecker(this, name, desc);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this._className = name.replace('/', '.');
        this._superClassName = superName == null ? null : superName.replace('/', '.');
        this._interfaces = interfaces;
        this.isInterface = (access & 0x200) > 0;
        this.collectSuperClassInfo();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc != null && desc.indexOf(JUNIT4_TESTRUNNER_ANNOTATION) >= 0) {
            this.setJUnit4TestAnnotation(true);
        }
        return super.visitAnnotation(desc, visible);
    }

    protected void collectSuperClassInfo() {
        if ("java.lang.Object".equals(this._className)) {
            return;
        }
        if (this.getSuperClassName() == null) {
            return;
        }
        ClassReader cr = null;
        try {
            cr = new ClassReader(this.getSuperClassName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        AsmClassChecker acc = new AsmClassChecker();
        cr.accept((ClassVisitor)acc, 4);
        this.setSuperClassChecker(acc);
    }

    protected boolean hasTestInterface(String[] interfaces) {
        if (interfaces == null) {
            return false;
        }
        int i = 0;
        while (i < interfaces.length) {
            if (JUNIT_TEST_INTERFACENAME.equals(interfaces[i].replace('/', '.'))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

