/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock;

import jp.co.dgic.testing.common.DJUnitRuntimeException;
import jp.co.dgic.testing.common.virtualmock.ArgumentValueList;
import jp.co.dgic.testing.common.virtualmock.IReturnValueProvider;
import jp.co.dgic.testing.common.virtualmock.IgnoreMethodValue;
import jp.co.dgic.testing.common.virtualmock.MockObjectManager;
import jp.co.dgic.testing.common.virtualmock.NullReturnValue;
import jp.co.dgic.testing.common.virtualmock.ReturnValueList;

public class InternalMockObjectManager {
    private static ReturnValueList testData = new ReturnValueList();
    private static ArgumentValueList callsMade = new ArgumentValueList();

    public static void initialize() {
        testData.clear();
        callsMade.clear();
    }

    public static ReturnValueList getTestData() {
        return testData;
    }

    public static ArgumentValueList getCallsMade() {
        return callsMade;
    }

    public static boolean isIgnoreMethodValue(String classAndMethodName) {
        Object value = testData.get(classAndMethodName, false);
        if (value == null) {
            return false;
        }
        return value instanceof IgnoreMethodValue;
    }

    public static void indicateCalled(String className, String methodName, Object[] arguments) {
        InternalMockObjectManager.indicateCalled(InternalMockObjectManager.makeKey(className, methodName), arguments);
    }

    public static void indicateCalled(String classAndMethodName, Object[] arguments) {
        InternalMockObjectManager.printIndicateCalled(classAndMethodName, arguments);
        callsMade.put(classAndMethodName, arguments);
    }

    public static Object indicateCalledAndGetReturnValue(String className, String methodName, Object[] arguments) throws Throwable {
        return InternalMockObjectManager.indicateCalledAndGetReturnValue(InternalMockObjectManager.makeKey(className, methodName), arguments);
    }

    public static Object indicateCalledAndGetReturnValue(String classAndMethodName, Object[] arguments) throws Throwable {
        InternalMockObjectManager.indicateCalled(classAndMethodName, arguments);
        Object value = MockObjectManager.getReturnValue(classAndMethodName);
        if (value == null) {
            return null;
        }
        if (value instanceof IReturnValueProvider) {
            Object providedValue = ((IReturnValueProvider)value).createReturnValue(arguments);
            value = providedValue == null ? new NullReturnValue() : providedValue;
        }
        return value;
    }

    public static Object indicateCalledAndGetReturnValueForNewExpr(String className, String methodName, Object[] arguments, boolean isOwnSource) throws Throwable {
        return InternalMockObjectManager.indicateCalledAndGetReturnValueForNewExpr(InternalMockObjectManager.makeKey(className, methodName), arguments, isOwnSource);
    }

    public static Object indicateCalledAndGetReturnValueForNewExpr(String classAndMethodName, Object[] arguments, boolean isOwnSource) throws Throwable {
        if (!isOwnSource) {
            InternalMockObjectManager.indicateCalled(classAndMethodName, arguments);
        }
        Object value = null;
        if (isOwnSource) {
            if (!InternalMockObjectManager.isIgnoreMethodValue(classAndMethodName)) {
                value = MockObjectManager.getReturnValue(classAndMethodName);
            }
        } else {
            value = MockObjectManager.getReturnValue(classAndMethodName);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof IReturnValueProvider) {
            Object providedValue = ((IReturnValueProvider)value).createReturnValue(arguments);
            value = providedValue == null ? new NullReturnValue() : providedValue;
        }
        return value;
    }

    public static void throwException(Object value, String className, String methodName) {
        InternalMockObjectManager.throwException(value, String.valueOf(className) + "#" + methodName);
    }

    public static void throwException(Object value, String classAndMethodName) {
        if (value instanceof RuntimeException) {
            throw (RuntimeException)value;
        }
        if (value instanceof Error) {
            throw (Error)value;
        }
        if (value instanceof Throwable) {
            throw new DJUnitRuntimeException(InternalMockObjectManager.createMismatchExceptionTypeMessage(value, classAndMethodName));
        }
    }

    public static void checkReturnTypeIsIgnoreReturnValue(Object value, String className, String methodName) {
        InternalMockObjectManager.checkReturnTypeIsIgnoreReturnValue(value, String.valueOf(className) + "#" + methodName);
    }

    public static void checkReturnTypeIsIgnoreReturnValue(Object value, String classAndMethodName) {
        if (value instanceof IgnoreMethodValue) {
            return;
        }
        throw new DJUnitRuntimeException(InternalMockObjectManager.createMismatchReturnTypeMessage(value, classAndMethodName));
    }

    public static void checkReturnTypeIsIgnoreOrNullReturnValue(Object value, String className, String methodName) {
        InternalMockObjectManager.checkReturnTypeIsIgnoreOrNullReturnValue(value, String.valueOf(className) + "#" + methodName);
    }

    public static void checkReturnTypeIsIgnoreOrNullReturnValue(Object value, String classAndMethodName) {
        if (value instanceof IgnoreMethodValue) {
            return;
        }
        if (value instanceof NullReturnValue) {
            return;
        }
        throw new DJUnitRuntimeException(InternalMockObjectManager.createMismatchReturnTypeMessage(value, classAndMethodName));
    }

    public static void checkReturnTypeIsNullReturnValue(Object value, String className, String methodName) {
        InternalMockObjectManager.checkReturnTypeIsNullReturnValue(value, String.valueOf(className) + "#" + methodName);
    }

    public static void checkReturnTypeIsNullReturnValue(Object value, String classAndMethodName) {
        if (value instanceof NullReturnValue) {
            return;
        }
        throw new DJUnitRuntimeException(InternalMockObjectManager.createMismatchReturnTypeMessage(value, classAndMethodName));
    }

    public static void checkReturnTypeForNewExpr(Object value, String className, String methodName) {
        InternalMockObjectManager.checkReturnTypeForNewExpr(value, String.valueOf(className) + "#" + methodName);
    }

    public static void checkReturnTypeForNewExpr(Object value, String classAndMethodName) {
        if (!(value instanceof NullReturnValue)) {
            if (value instanceof IgnoreMethodValue) {
                throw new DJUnitRuntimeException(InternalMockObjectManager.createCannotSetObjectTypeMessage(classAndMethodName));
            }
            throw new DJUnitRuntimeException(InternalMockObjectManager.createMismatchReturnTypeMessage(value, classAndMethodName));
        }
    }

    private static String createMismatchExceptionTypeMessage(Object value, String classAndMethodName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Mismatch exception type.");
        sb.append("This method(");
        sb.append(classAndMethodName);
        sb.append(") can ");
        sb.append("NOT throws");
        sb.append(" [");
        sb.append(value.getClass().getName());
        sb.append("] type exception. ");
        return sb.toString();
    }

    private static String createMismatchReturnTypeMessage(Object value, String classAndMethodName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Mismatch return type.You can NOT set [");
        sb.append(value.getClass().getName());
        sb.append("] type return value into ");
        sb.append("this method(");
        sb.append(classAndMethodName);
        sb.append(").");
        return sb.toString();
    }

    private static String createCannotSetObjectTypeMessage(String classAndMethodName) {
        StringBuffer sb = new StringBuffer();
        sb.append("Mismatch object type.");
        sb.append("At");
        sb.append(classAndMethodName);
        sb.append(".");
        return sb.toString();
    }

    private static String makeKey(String className, String methodName) {
        return String.valueOf(className) + "." + methodName;
    }

    public static void printGetReturnValue(String classAndMethodNameName) {
        if (System.getProperty("test.debug") == null) {
            return;
        }
        InternalMockObjectManager.printConsole("[[[getReturnValue]]] : " + classAndMethodNameName);
    }

    private static void printIndicateCalled(String classAndMethodName, Object[] arguments) {
        if (System.getProperty("test.debug") == null) {
            return;
        }
        InternalMockObjectManager.printConsole("[[[indicateCalled]]] : " + classAndMethodName + ", " + arguments);
    }

    public static void printConsole(String message) {
        String debug = System.getProperty("test.debug");
        if (debug == null) {
            return;
        }
        System.out.println(message);
    }
}

