/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.ClickableFieldLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.FilesCanvas;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.OverallCanvas;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.PackagesCanvas;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.PageNavigation;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.html.HtmlReportExportProcess;
import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageMarkingProcess;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoveragePluginUtil;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoverageUtil;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.MarkerUtil;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitPlugin;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitProjectPropertyPage;
import jp.co.dgic.testing.common.coverage.CoverageEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class CoverageReportView
extends ViewPart {
    private static final int LINE_HEIGHT = 20;
    private static final FontData FONT_CONTENTS = new FontData("Courier New", 10, 1);
    private static final FontData FONT_TITLE = new FontData("Franklin Gothic Medium", 16, 1);
    private static final RGB RGB_TITLE = new RGB(0, 0, 0);
    private static final RGB RGB_BACKGROUND = new RGB(255, 255, 255);
    private static final RGB RGB_HEADER_BG = new RGB(0, 128, 0);
    private static final RGB RGB_HEADER_FG = new RGB(255, 255, 255);
    public static final String NAME = "jp.co.dgic.eclipse.jdt.coverage.CoverageReportView";
    private static final int LINES_PER_PAGE = 50;
    private ScrolledComposite scrolledComposite;
    private Canvas reportCanvas;
    private ClickableFieldLabel summaryLabel;
    private IProject currentProject;
    private Action exportHtmlAction;
    private Action refreshAction;
    private Action clearAction;
    private Action deleteMarkerAction;
    private Action createMarkerAction;
    private String packageNameFilter;
    private int currentPage = 1;
    private int maxPage = 1;
    private static String reportOutputDirectory;

    public void createPartControl(Composite parent) {
        this.createMenu();
        this.createButtons();
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        this.scrolledComposite.setBackground(new Color((Device)this.scrolledComposite.getDisplay(), RGB_BACKGROUND));
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getHorizontalBar().setIncrement(10);
        this.buildReportView();
    }

    public void buildReportView() {
        Control oldCanvas = this.scrolledComposite.getContent();
        if (oldCanvas != null) {
            oldCanvas.dispose();
        }
        this.reportCanvas = new Canvas((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.reportCanvas);
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        this.reportCanvas.setLayout((Layout)grid);
        this.reportCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CoverageReportView.this.draw(e.gc);
            }
        });
        this.reportCanvas.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
        this.setEnableMenuButtons();
        if (this.currentProject == null) {
            Label message = new Label((Composite)this.reportCanvas, 0);
            message.setText(DJUnitMessages.getString("CoverageReportView.message.noproject"));
            message.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
            message.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_TITLE));
            this.createEmptyLine();
            this.resizeReportCanvas();
            return;
        }
        Label projectNameLabel = new Label((Composite)this.reportCanvas, 16384);
        projectNameLabel.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
        projectNameLabel.setForeground(new Color((Device)this.reportCanvas.getDisplay(), RGB_TITLE));
        projectNameLabel.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_TITLE));
        projectNameLabel.setText(this.currentProject.getName());
        this.summaryLabel = new ClickableFieldLabel((Composite)this.reportCanvas, 0);
        this.summaryLabel.setText("coverage summary");
        this.summaryLabel.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_CONTENTS));
        this.summaryLabel.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_HEADER_BG));
        this.summaryLabel.setForeground(new Color((Device)this.reportCanvas.getDisplay(), RGB_HEADER_FG));
        this.summaryLabel.setSize(400, 20);
        this.summaryLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CoverageReportView.this.setPackageNameFilter(null);
                CoverageReportView.this.setCurrentPage(1);
                CoverageReportView.this.buildReportView();
            }
        });
        this.createEmptyLine();
        CoveragePluginUtil.setCoverageWorkingDirectory(this.currentProject);
        CoverageUtil.prepareCoverageEntry();
        Label title = new Label((Composite)this.reportCanvas, 16384);
        title.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
        title.setForeground(new Color((Device)this.reportCanvas.getDisplay(), RGB_TITLE));
        title.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_TITLE));
        title.setText("Coverage Report");
        this.createEmptyLine();
        if (this.packageNameFilter == null) {
            new OverallCanvas(this);
            this.createEmptyLine();
        }
        Label packagesTitle = new Label((Composite)this.reportCanvas, 16384);
        packagesTitle.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
        packagesTitle.setForeground(new Color((Device)this.reportCanvas.getDisplay(), RGB_TITLE));
        packagesTitle.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_TITLE));
        packagesTitle.setText("Packages");
        this.createEmptyLine();
        new PackagesCanvas(this);
        this.createEmptyLine();
        this.maxPage = this.calcMaxPage(this.calcFilteredMaxLineCount());
        Label filesTitle = new Label((Composite)this.reportCanvas, 16384);
        filesTitle.setBackground(new Color((Device)this.reportCanvas.getDisplay(), RGB_BACKGROUND));
        filesTitle.setForeground(new Color((Device)this.reportCanvas.getDisplay(), RGB_TITLE));
        filesTitle.setFont(new Font((Device)this.reportCanvas.getDisplay(), FONT_TITLE));
        filesTitle.setText("All files (" + this.currentPage + "/" + this.maxPage + " page)");
        if (this.maxPage > 1) {
            new PageNavigation(this, this.currentPage, this.maxPage);
        }
        new FilesCanvas(this, this.calcMinLineNumber(), this.calcMaxLineNumber());
        this.createEmptyLine();
        this.resizeReportCanvas();
    }

    public void movePage(int pageNumber) {
        this.setCurrentPage(pageNumber);
        this.buildReportView();
    }

    public void prevPage() {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.buildReportView();
    }

    public void nextPage() {
        if (this.currentPage >= this.maxPage) {
            return;
        }
        ++this.currentPage;
        this.buildReportView();
    }

    public void setCurrentPage(int pageNumber) {
        this.currentPage = pageNumber;
    }

    private int calcMinLineNumber() {
        return (this.currentPage - 1) * 50;
    }

    private int calcMaxLineNumber() {
        return this.currentPage * 50;
    }

    private int calcMaxPage(long lineCount) {
        return (int)Math.ceil((double)lineCount / 50.0);
    }

    private int calcFilteredMaxLineCount() {
        int count = 0;
        Map entries = CoverageUtil.getFileCoverage();
        Iterator it = entries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            CoverageEntry entry = (CoverageEntry)me.getValue();
            if (this.isFilteredPackage(entry)) continue;
            ++count;
        }
        return count;
    }

    private boolean isFilteredPackage(CoverageEntry entry) {
        String packageName = this.getPackageNameFilter();
        if (packageName == null) {
            return false;
        }
        if (packageName.equalsIgnoreCase("default")) {
            return entry.getName().indexOf(46) >= 0;
        }
        return !entry.getName().startsWith(String.valueOf(packageName) + ".");
    }

    private void resizeReportCanvas() {
        this.reportCanvas.setSize(this.reportCanvas.computeSize(-1, -1));
    }

    private void createEmptyLine() {
        new Label((Composite)this.reportCanvas, 0);
    }

    public Canvas getReportCanvas() {
        return this.reportCanvas;
    }

    public void setFocus() {
        this.reportCanvas.setFocus();
    }

    private void draw(GC gc) {
        if (this.summaryLabel != null) {
            gc.fillRectangle(this.reportCanvas.getClientArea());
            this.summaryLabel.setSize(this.reportCanvas.getClientArea().width, 20);
        }
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        IProject[] projects = this.getAllProjects();
        if (projects == null) {
            return;
        }
        int idx = 0;
        while (idx < projects.length) {
            if (projects[idx].isOpen()) {
                mgr.add((IAction)this.createAction(projects[idx]));
            }
            ++idx;
        }
    }

    private void createButtons() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.exportHtmlAction = new Action(){

            public void run() {
                CoverageReportView.this.exportHtmlReport();
            }
        };
        this.exportHtmlAction.setImageDescriptor(this.getImageDescriptor("full/djunit/export_html.gif"));
        this.exportHtmlAction.setDisabledImageDescriptor(this.getImageDescriptor("full/djunit/export_html_g.gif"));
        this.exportHtmlAction.setToolTipText("Export");
        this.exportHtmlAction.setEnabled(this.currentProject != null);
        this.refreshAction = new Action(){

            public void run() {
                CoverageReportView.this.packageNameFilter = null;
                CoverageReportView.this.setCurrentPage(1);
                CoverageReportView.this.buildReportView();
                MarkerUtil.clearCoverageMarker(CoverageReportView.this.currentProject);
                CoverageReportView.this.updateCoverageMarker();
            }
        };
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("full/djunit/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("full/djunit/refresh_g.gif"));
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setEnabled(this.currentProject != null);
        this.clearAction = new Action(){

            public void run() {
                CoverageReportView.this.packageNameFilter = null;
                CoverageReportView.this.setCurrentPage(1);
                if (CoverageReportView.this.currentProject == null) {
                    return;
                }
                CoverageReportView.this.clearCoverage();
            }
        };
        this.clearAction.setImageDescriptor(this.getImageDescriptor("full/djunit/removeall.gif"));
        this.clearAction.setDisabledImageDescriptor(this.getImageDescriptor("full/djunit/removeall_g.gif"));
        this.clearAction.setToolTipText("Clear");
        this.clearAction.setEnabled(this.currentProject != null);
        this.deleteMarkerAction = new Action(){

            public void run() {
                MarkerUtil.clearCoverageMarker(CoverageReportView.this.currentProject);
            }
        };
        this.deleteMarkerAction.setImageDescriptor(this.getImageDescriptor("full/djunit/deletemarker.gif"));
        this.deleteMarkerAction.setDisabledImageDescriptor(this.getImageDescriptor("full/djunit/deletemarker_g.gif"));
        this.deleteMarkerAction.setToolTipText("Delete marker");
        this.deleteMarkerAction.setEnabled(this.currentProject != null);
        this.createMarkerAction = new Action(){

            public void run() {
                MarkerUtil.clearCoverageMarker(CoverageReportView.this.currentProject);
                CoverageReportView.this.updateCoverageMarker();
            }
        };
        this.createMarkerAction.setImageDescriptor(this.getImageDescriptor("full/djunit/createmarker.gif"));
        this.createMarkerAction.setDisabledImageDescriptor(this.getImageDescriptor("full/djunit/createmarker_g.gif"));
        this.createMarkerAction.setToolTipText("Create marker");
        this.createMarkerAction.setEnabled(this.currentProject != null);
        mgr.add((IAction)this.exportHtmlAction);
        mgr.add((IAction)this.refreshAction);
        mgr.add((IAction)this.clearAction);
        mgr.add((IAction)this.deleteMarkerAction);
        mgr.add((IAction)this.createMarkerAction);
    }

    private Action createAction(IProject project) {
        return new CoverageAction(project){

            public void run() {
                CoverageReportView.this.currentProject = this.project;
                CoverageReportView.this.packageNameFilter = null;
                CoverageReportView.this.setEnableMenuButtons();
                CoverageReportView.this.buildReportView();
            }
        };
    }

    private void setEnableMenuButtons() {
        if (this.exportHtmlAction != null) {
            this.exportHtmlAction.setEnabled(this.currentProject != null);
        }
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(this.currentProject != null);
        }
        if (this.clearAction != null) {
            this.clearAction.setEnabled(this.currentProject != null);
        }
        if (this.deleteMarkerAction != null) {
            this.deleteMarkerAction.setEnabled(this.currentProject != null);
        }
        if (this.createMarkerAction != null) {
            this.createMarkerAction.setEnabled(this.currentProject != null);
        }
    }

    private IProject[] getAllProjects() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getProjects();
    }

    public IProject getProject() {
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
    }

    public IJavaProject getJavaProject() {
        try {
            return (IJavaProject)this.currentProject.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPackageNameFilter() {
        return this.packageNameFilter;
    }

    public void setPackageNameFilter(String packageName) {
        this.packageNameFilter = packageName;
    }

    public void asyncBuildView() {
        this.getViewSite().getShell().getDisplay().asyncExec((Runnable)new ViewUpdateThread());
    }

    public void clearCoverage() {
        CoveragePluginUtil.deleteCoverageResults(this.currentProject);
        MarkerUtil.clearCoverageMarker(this.currentProject);
        this.packageNameFilter = null;
        this.buildReportView();
    }

    private ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        try {
            URL installURL = Platform.getBundle((String)"jp.co.dgic.eclipse.jdt.djunit").getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            DJUnitPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void updateCoverageMarker() {
        try {
            CoverageMarkingProcess markingProcess = new CoverageMarkingProcess(this.getJavaProject());
            markingProcess.setUser(true);
            markingProcess.schedule();
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
        }
    }

    private void exportHtmlReport() {
        try {
            String outputDirectory = this.getReportOutputDirectory();
            if (outputDirectory == null) {
                return;
            }
            reportOutputDirectory = outputDirectory;
            String[] args = new String[]{"-i", String.valueOf(this.getCoverageWorkingDirectory()) + "/jcoverage.ser", "-s", this.getSourceDirectories(), "-o", outputDirectory};
            HtmlReportExportProcess exportProcess = new HtmlReportExportProcess(args);
            Shell shell = new Shell(Display.getDefault());
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(shell);
            monitorDialog.run(true, true, (IRunnableWithProgress)exportProcess);
        }
        catch (Throwable t) {
            DJUnitPlugin.log(t);
            String message = t.getMessage();
            if (t.getMessage() == null) {
                message = t.toString();
            }
            MessageBox md = new MessageBox(new Shell(Display.getDefault()), 33);
            md.setText("Error");
            md.setMessage(message);
            md.open();
        }
    }

    private String getSourceDirectories() throws CoreException {
        StringBuffer sb = new StringBuffer();
        try {
            IPackageFragmentRoot[] roots = this.getJavaProject().getAllPackageFragmentRoots();
            int idx = 0;
            while (idx < roots.length) {
                int kind = roots[idx].getKind();
                if (kind == 1) {
                    sb.append(roots[idx].getResource().getLocation());
                    sb.append(";");
                }
                ++idx;
            }
        }
        catch (JavaModelException e) {
            throw new CoreException(e.getStatus());
        }
        return sb.toString();
    }

    private String getCoverageWorkingDirectory() {
        String directoryName = DJUnitProjectPropertyPage.readWorkingDirectory(this.currentProject);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource directory = null;
        if (directoryName != null) {
            directory = workspaceRoot.findMember(String.valueOf(this.currentProject.getProject().getName()) + directoryName);
        }
        return directory.getLocation().toString();
    }

    public boolean getUseCoverageMarker() {
        return DJUnitProjectPropertyPage.readUseMarker(this.currentProject);
    }

    private String getReportOutputDirectory() {
        DirectoryDialog dd = new DirectoryDialog(this.getSite().getShell());
        dd.setText(DJUnitMessages.getString("CoverageReportView.message.export.output.title"));
        dd.setMessage(DJUnitMessages.getString("CoverageReportView.message.export.output.message"));
        if (reportOutputDirectory == null) {
            reportOutputDirectory = this.currentProject.getLocation().toString();
        }
        dd.setFilterPath(reportOutputDirectory);
        return dd.open();
    }

    private class CoverageAction
    extends Action {
        protected IProject project;

        public CoverageAction(IProject project) {
            super(project.getName());
            this.project = project;
        }
    }

    private class ViewUpdateThread
    implements Runnable {
        private ViewUpdateThread() {
        }

        public void run() {
            CoverageReportView.this.buildReportView();
        }
    }
}

