/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.asm;

import com.jcoverage.coverage.InstrumentData;
import com.jcoverage.coverage.asm.AsmMethodInstrumenter;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class AsmClassInstrumenter
extends ClassAdapter {
    private InstrumentData instrumentData;
    private String className;

    public String getClassName() {
        return this.className;
    }

    public AsmClassInstrumenter(ClassVisitor cv) {
        super(cv);
    }

    public InstrumentData getInstrumentData() {
        return this.instrumentData;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name.replace('/', '.');
        this.instrumentData = new InstrumentData(this.className);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.instrumentData.setSourceFileName(source);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        this.instrumentData.addMethodNamesAndSignatures(name, desc);
        return new AsmMethodInstrumenter(mv, this.className, name, desc, this.instrumentData);
    }
}

