/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.Instrument;
import com.jcoverage.coverage.InstrumentClassGen;
import com.jcoverage.coverage.InstrumentationFactory;
import com.jcoverage.coverage.InstrumentationInternal;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoverageUtil;
import jp.co.dgic.testing.common.AbstractBcelModifier;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import org.apache.bcel.classfile.JavaClass;

public class BcelCoverageInstrumenter
extends AbstractBcelModifier {
    private Instrument inst = new Instrument();

    public BcelCoverageInstrumenter() {
        super("Coverage");
    }

    protected byte[] modify(JavaClass jc) throws Exception {
        return this.instrument(jc);
    }

    private byte[] instrument(JavaClass jc) {
        String className = jc.getClassName();
        if (!CoverageUtil.isUseCoverage()) {
            return null;
        }
        if (!CoverageUtil.isIncluded(className)) {
            return null;
        }
        if (CoverageUtil.isExcluded(className)) {
            return null;
        }
        InternalMockObjectManager.printConsole("[instrument] " + className);
        if (this.inst.isInterface(jc) || this.inst.isAlreadyInstrumented(jc)) {
            InternalMockObjectManager.printConsole(String.valueOf(className) + " is isInterface or isAlreadyInstrumented.");
            return jc.getBytes();
        }
        InstrumentClassGen instrument = new InstrumentClassGen(jc, this.inst.ignoreRegex);
        instrument.addInstrumentation();
        InstrumentationInternal i = (InstrumentationInternal)InstrumentationFactory.getInstance().newInstrumentation(jc.getClassName());
        if (instrument.getSourceLineNumbers().isEmpty()) {
            System.out.println("no source line numbers found for: " + jc.getClassName() + ", compile with debug=\"yes\".");
        }
        i.setSourceLineNumbers(instrument.getSourceLineNumbers());
        i.setSourceFileName(jc.getSourceFileName());
        i.setSourceLineNumbersByMethod(instrument.getMethodLineNumbers());
        i.setConditionalsByMethod(instrument.getMethodConditionals());
        i.setMethodNamesAndSignatures(instrument.getMethodNamesAndSignatures());
        return instrument.getClassGen().getJavaClass().getBytes();
    }
}

