/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.InstrumentData;
import com.jcoverage.coverage.InstrumentationFactory;
import com.jcoverage.coverage.InstrumentationInternal;
import com.jcoverage.coverage.asm.AsmClassInstrumenter;
import jp.co.dgic.eclipse.jdt.internal.coverage.util.CoverageUtil;
import jp.co.dgic.testing.common.AbstractAsmModifier;
import jp.co.dgic.testing.common.virtualmock.asm.AsmClassChecker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class AsmCoverageInstrumenter
extends AbstractAsmModifier {
    public AsmCoverageInstrumenter() {
        super("Coverage");
    }

    protected byte[] modify(String className, ClassReader cr) throws Exception {
        if (!CoverageUtil.isUseCoverage()) {
            return null;
        }
        if (!CoverageUtil.isIncluded(className)) {
            return null;
        }
        if (CoverageUtil.isExcluded(className)) {
            return null;
        }
        AsmClassChecker acc = new AsmClassChecker();
        cr.accept((ClassVisitor)acc, 4);
        if (acc.isInterface()) {
            return null;
        }
        ClassWriter cw = new ClassWriter(1);
        AsmClassInstrumenter cv = new AsmClassInstrumenter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 4);
        InstrumentationInternal i = (InstrumentationInternal)InstrumentationFactory.getInstance().newInstrumentation(className);
        InstrumentData data = cv.getInstrumentData();
        i.setSourceLineNumbers(data.getSourceLineNumbers());
        i.setSourceFileName(data.getSourceFileName());
        i.setSourceLineNumbersByMethod(data.getMethodLineNumbers());
        i.setConditionalsByMethod(data.getMethodConditionals());
        i.setMethodNamesAndSignatures(data.getMethodNamesAndSignatures());
        return cw.toByteArray();
    }
}

