/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.reporting.html;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.DefaultColumnRenderer;
import com.jcoverage.reporting.html.Writable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ReportTable
implements Writable {
    public static final ColumnRenderer DEFAULT_COLUMN_RENDERER = new DefaultColumnRenderer();
    Page page;
    Set records;
    Column[] columns;
    FormattingContext ctx;
    ColumnRenderer[] columnRenderers;
    Map registeredDefaultColumnRenderers = new HashMap();

    public ReportTable(Page page, Set records, Column[] columns, FormattingContext ctx) {
        this.page = page;
        this.records = records;
        this.columns = columns;
        this.ctx = ctx;
        this.columnRenderers = new ColumnRenderer[columns.length];
    }

    public void setColumnRenderer(Column column, ColumnRenderer renderer) {
        this.registeredDefaultColumnRenderers.put(column, renderer);
    }

    public void setColumnRenderer(Column column, ColumnRenderer renderer, int colnum) {
        if (!this.columns[colnum].equals(column)) {
            throw new IllegalArgumentException("Column number does not correspond to given column. Given column is " + column + " but column number corresponds to column " + this.columns[colnum]);
        }
        this.columnRenderers[colnum] = renderer;
    }

    void fillColumnRenderers() {
        int i = 0;
        while (i < this.columnRenderers.length) {
            if (this.columnRenderers[i] == null) {
                ColumnRenderer defaultColumnRenderer = (ColumnRenderer)this.registeredDefaultColumnRenderers.get(this.columns[i]);
                this.columnRenderers[i] = defaultColumnRenderer != null ? defaultColumnRenderer : DEFAULT_COLUMN_RENDERER;
            }
            ++i;
        }
    }

    public void writeTo(PrintWriter writer) {
        this.fillColumnRenderers();
        writer.println("<table cellpadding=\"2\" cellspacing=\"0\" width=\"85%\">");
        writer.print("<tr>");
        int i = 0;
        while (i < this.columns.length) {
            this.columnRenderers[i].renderTitle(this.ctx, writer, this.columns[i], i == this.columns.length - 1);
            ++i;
        }
        writer.println("</tr>");
        int rownum = 0;
        Iterator it = this.records.iterator();
        while (it.hasNext()) {
            String cssClass = rownum % 2 == 0 ? "yin" : "yang";
            ++rownum;
            Line line = (Line)it.next();
            Page detail = line.getDetailPage();
            String href = null;
            if (detail != null) {
                href = this.ctx.getCollator().getPathToPage(this.ctx, detail, this.page);
            }
            writer.println("<tr class=\"" + cssClass + "\">");
            int i2 = 0;
            while (i2 < this.columns.length) {
                this.columnRenderers[i2].renderField(this.ctx, writer, this.columns[i2], line, href);
                ++i2;
            }
            writer.println("</tr>");
        }
        writer.println("</table>");
    }
}

