/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.html;

import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.reporting.html.HtmlFormatHelper;
import com.jcoverage.reporting.html.Writable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class SourceTable
implements Writable {
    File sourceFile;
    JavaFilePage page;

    public SourceTable(File sourceFile, JavaFilePage page) {
        this.sourceFile = sourceFile;
        this.page = page;
    }

    public void writeTo(PrintWriter writer) {
        writer.println("<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"85%\">");
        writer.print("<tr>");
        writer.print("<th>Line</th>");
        writer.print("<th>Hits</th>");
        writer.print("<th class=\"remainder\">Source</th>");
        writer.println("</tr>");
        int lineNo = 1;
        try {
            String remainder;
            BufferedReader source = new BufferedReader(new InputStreamReader(new FileInputStream(this.sourceFile)));
            Iterator coverage = this.page.getSourceFileLineCoverageSet().iterator();
            while (coverage.hasNext()) {
                String line;
                Map.Entry entry = (Map.Entry)coverage.next();
                int nextLineNo = (Integer)entry.getKey();
                while (lineNo < nextLineNo) {
                    line = source.readLine();
                    if (line == null) break;
                    this.writeRow(writer, this.page, lineNo, 0L, SourceTable.indentSource(line));
                    ++lineNo;
                }
                if (lineNo != nextLineNo) continue;
                line = source.readLine();
                if (line == null) break;
                this.writeRow(writer, this.page, nextLineNo, (Long)entry.getValue(), SourceTable.indentSource(line));
                ++lineNo;
            }
            while ((remainder = source.readLine()) != null) {
                this.writeRow(writer, this.page, lineNo, 0L, SourceTable.indentSource(remainder));
                ++lineNo;
            }
        }
        catch (Exception ex) {
            writer.println("<p>Failed to read java source file: ");
            writer.println("<pre>");
            writer.println(ex.toString());
            writer.println("</pre>");
        }
        writer.println("</table>");
    }

    private void writeRow(PrintWriter writer, JavaFilePage page, int lineNo, long hits, String line) {
        String cssClass = lineNo % 2 == 0 ? "yin" : "yang";
        boolean validLine = page.getValidSourceLines().contains(new Integer(lineNo));
        if (validLine && hits == 0L) {
            cssClass = "highlight";
        }
        writer.print("<tr class=\"" + cssClass + "\">");
        this.writeCell(writer, String.valueOf(lineNo), "lineno");
        if (validLine) {
            this.writeCell(writer, String.valueOf(hits), "hits");
        } else {
            this.writeCell(writer, "&nbsp;", "hits");
        }
        this.writeCell(writer, "<tt>" + line + "</tt>", "code");
        writer.println("</tr>");
    }

    void writeCell(PrintWriter writer, String content, String cssClass) {
        writer.print("<td class=\"" + cssClass + "\">" + content + "</td>");
    }

    static String indentSource(String line) {
        StringBuffer sb = new StringBuffer(HtmlFormatHelper.replaceCharacterEntities(HtmlFormatHelper.untabify(line, 4)));
        StringBuffer newsb = new StringBuffer();
        int i = 0;
        while (i < sb.length() && sb.charAt(i) == ' ') {
            ++i;
            newsb.append("&nbsp;");
        }
        newsb.append(sb.substring(i));
        if (newsb.length() == 0) {
            newsb.append("&nbsp;");
        }
        return newsb.toString();
    }
}

