/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.Conditional;
import com.jcoverage.coverage.HasBeenInstrumented;
import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.InstrumentationInternal;
import com.jcoverage.util.SetHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class InstrumentationImpl
implements InstrumentationInternal,
HasBeenInstrumented {
    static final long serialVersionUID = 247748305779236308L;
    static final transient Long ZERO = new Long(0L);
    final Map lineCounts = new TreeMap();
    final Set sourceLineNumbers = new TreeSet();
    final Map sourceLineNumbersByMethod = new TreeMap();
    final Map conditionalsByMethod = new TreeMap();
    final Set methodNamesAndSignatures = new TreeSet();
    int linesOfCode = 0;
    String sourceFileName;

    InstrumentationImpl() {
    }

    public Map getCoverage() {
        return Collections.unmodifiableMap(this.lineCounts);
    }

    public long getCoverage(int lineNumber) {
        return this.getLineCount(lineNumber);
    }

    public void touch(int lineNumber) {
        Integer key = new Integer(lineNumber);
        this.setLineCount(key, this.increment(this.getLineCount(key)));
    }

    public void merge(Instrumentation instrumentation) {
        this.sourceLineNumbers.addAll(instrumentation.getSourceLineNumbers());
        this.methodNamesAndSignatures.addAll(instrumentation.getMethodNamesAndSignatures());
        this.sourceLineNumbersByMethod.putAll(((InstrumentationImpl)instrumentation).getSourceLineNumbersByMethod());
        this.conditionalsByMethod.putAll(((InstrumentationImpl)instrumentation).getConditionalsByMethod());
        Iterator i = instrumentation.getCoverage().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (this.lineCounts.containsKey(entry.getKey())) {
                long total = (Long)entry.getValue() + this.getLineCount((Integer)entry.getKey());
                this.setLineCount((Integer)entry.getKey(), new Long(total));
                continue;
            }
            this.setLineCount((Integer)entry.getKey(), (Long)entry.getValue());
        }
        if (this.getSourceFileName() == null) {
            this.setSourceFileName(instrumentation.getSourceFileName());
        }
    }

    public Set getSourceLineNumbers() {
        return Collections.unmodifiableSet(this.sourceLineNumbers);
    }

    public void setSourceLineNumbers(Set sourceLineNumbers) {
        this.sourceLineNumbers.addAll(sourceLineNumbers);
    }

    public double getLineCoverageRate() {
        if (this.sourceLineNumbers.size() == 0) {
            return 1.0;
        }
        return (double)this.lineCounts.keySet().size() / (double)this.sourceLineNumbers.size();
    }

    public double getBranchCoverageRate() {
        double sum = 1.0;
        int requiredHitCount = 0;
        int hitCount = 0;
        Iterator i = this.sourceLineNumbersByMethod.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set requiredHits = this.getRequiredHits(key);
            int count = this.getHitCountInRequired(key, requiredHits);
            this.printConsole("[Required hits] " + this.sourceFileName + "#" + key + " - " + requiredHits);
            requiredHitCount += requiredHits.size();
            hitCount += count;
        }
        if (requiredHitCount != 0) {
            sum = (double)hitCount / (double)requiredHitCount;
        }
        return sum;
    }

    public double getLineCoverageRate(String methodNameAndSignature) {
        if (!this.sourceLineNumbersByMethod.containsKey(methodNameAndSignature)) {
            throw new IllegalArgumentException(methodNameAndSignature);
        }
        Set lineNumbers = (Set)this.sourceLineNumbersByMethod.get(methodNameAndSignature);
        if (lineNumbers.size() == 0) {
            return 1.0;
        }
        int count = 0;
        Iterator i = lineNumbers.iterator();
        while (i.hasNext()) {
            if (this.getLineCount((Integer)i.next()) <= 0L) continue;
            ++count;
        }
        return (double)count / (double)lineNumbers.size();
    }

    Set getTouchedLines(String methodNameAndSignature) {
        TreeSet<Integer> results = new TreeSet<Integer>();
        Iterator i = ((Set)this.sourceLineNumbersByMethod.get(methodNameAndSignature)).iterator();
        while (i.hasNext()) {
            Integer lineNumber = (Integer)i.next();
            if (this.getLineCount(lineNumber) <= 0L) continue;
            results.add(lineNumber);
        }
        return results;
    }

    public double getBranchCoverageRate(String methodNameAndSignature) {
        if (!this.sourceLineNumbersByMethod.containsKey(methodNameAndSignature)) {
            throw new IllegalArgumentException(methodNameAndSignature);
        }
        Set conditionals = (Set)this.conditionalsByMethod.get(methodNameAndSignature);
        if (conditionals.size() == 0) {
            return 1.0;
        }
        TreeSet<Integer> requiredHits = new TreeSet<Integer>();
        Iterator i = conditionals.iterator();
        while (i.hasNext()) {
            Conditional conditional = (Conditional)i.next();
            requiredHits.add(this.findNextSourceLineAfter(methodNameAndSignature, conditional.getLineNumber()));
            requiredHits.add(new Integer(conditional.getTargetLineNumber()));
        }
        return (double)SetHelper.intersection(requiredHits, this.getTouchedLines(methodNameAndSignature)).size() / (double)requiredHits.size();
    }

    private int getHitCountInRequired(String methodNameAndSignature, Set requiredHits) {
        return SetHelper.intersection(requiredHits, this.getTouchedLines(methodNameAndSignature)).size();
    }

    private Set getRequiredHits(String methodNameAndSignature) {
        TreeSet<Integer> requiredHits = new TreeSet<Integer>();
        Set conditionals = (Set)this.conditionalsByMethod.get(methodNameAndSignature);
        if (conditionals.size() == 0) {
            return requiredHits;
        }
        Iterator i = conditionals.iterator();
        while (i.hasNext()) {
            int targetLine;
            Integer nextSourceAfter;
            Conditional conditional = (Conditional)i.next();
            int lineNumber = conditional.getLineNumber();
            if (lineNumber >= 0) {
                requiredHits.add(new Integer(lineNumber));
            }
            if ((nextSourceAfter = this.findNextSourceLineAfter(methodNameAndSignature, conditional.getLineNumber())) != null && nextSourceAfter > 0) {
                requiredHits.add(this.findNextSourceLineAfter(methodNameAndSignature, conditional.getLineNumber()));
            }
            if ((targetLine = conditional.getTargetLineNumber()) <= 0) continue;
            requiredHits.add(new Integer(conditional.getTargetLineNumber()));
        }
        return requiredHits;
    }

    Integer findNextSourceLineAfter(String methodNameAndSignature, int thisOne) {
        if (thisOne <= 0) {
            return new Integer(0);
        }
        Iterator i = ((Set)this.sourceLineNumbersByMethod.get(methodNameAndSignature)).iterator();
        Integer lineNumber = new Integer(0);
        while (i.hasNext()) {
            Integer line = (Integer)i.next();
            if (line <= thisOne) continue;
            lineNumber = line;
            break;
        }
        return lineNumber;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    private Long increment(Long count) {
        return new Long(count + 1L);
    }

    private Long getLineCount(int lineNumber) {
        return this.getLineCount(new Integer(lineNumber));
    }

    private Long getLineCount(Integer lineNumber) {
        if (!this.lineCounts.containsKey(lineNumber)) {
            this.lineCounts.put(lineNumber, ZERO);
        }
        return (Long)this.lineCounts.get(lineNumber);
    }

    private void setLineCount(Integer lineNumber, Long lineCount) {
        this.lineCounts.put(lineNumber, lineCount);
    }

    public Map getSourceLineNumbersByMethod() {
        return this.sourceLineNumbersByMethod;
    }

    public void setSourceLineNumbersByMethod(Map sourceLineNumbersByMethod) {
        this.sourceLineNumbersByMethod.putAll(sourceLineNumbersByMethod);
    }

    public Map getConditionalsByMethod() {
        return this.conditionalsByMethod;
    }

    public void setConditionalsByMethod(Map conditionalsByMethod) {
        this.conditionalsByMethod.putAll(conditionalsByMethod);
    }

    public Set getMethodNamesAndSignatures() {
        return this.methodNamesAndSignatures;
    }

    public void setMethodNamesAndSignatures(Set x) {
        this.methodNamesAndSignatures.addAll(x);
    }

    private void printConsole(Object object) {
        String value = System.getProperty("coverage.debug");
        if (value == null || !"true".equalsIgnoreCase(value)) {
            return;
        }
        System.out.println(object);
    }
}

