/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage;

import com.jcoverage.coverage.CoverageRuntimeException;
import com.jcoverage.coverage.InstrumentClassGen;
import com.jcoverage.coverage.InstrumentationFactory;
import com.jcoverage.coverage.InstrumentationInternal;
import com.jcoverage.util.ClassHelper;
import com.jcoverage.util.JavaClassHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.JavaClass;

public class Instrument {
    File destinationDirectory = null;
    String ignoreRegex = null;
    File baseDir = null;
    static /* synthetic */ Class class$0;

    boolean isClass(File fi) {
        return fi.getName().endsWith(".class");
    }

    boolean isAlreadyInstrumented(JavaClass jc) {
        String[] interfaceNames = jc.getInterfaceNames();
        int i = 0;
        while (i < interfaceNames.length) {
            String string = interfaceNames[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("com.jcoverage.coverage.HasBeenInstrumented");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isInterface(JavaClass jc) {
        return !jc.isClass();
    }

    void instrument(File clazz) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(clazz);
            JavaClass jc = JavaClassHelper.newJavaClass(is, clazz.getName());
            ((InputStream)is).close();
            is = null;
            if (this.isInterface(jc) || this.isAlreadyInstrumented(jc)) {
                if (this.destinationDirectory != null) {
                    File outputDirectory = new File(this.destinationDirectory, ClassHelper.getPackageName(jc.getClassName()).replace('.', '/'));
                    outputDirectory.mkdirs();
                    jc.dump(new File(outputDirectory, String.valueOf(ClassHelper.getBaseName(jc.getClassName())) + ".class"));
                }
                return;
            }
            InstrumentClassGen instrument = new InstrumentClassGen(jc, this.ignoreRegex);
            instrument.addInstrumentation();
            if (this.destinationDirectory == null) {
                instrument.getClassGen().getJavaClass().dump(clazz);
            } else {
                File outputDirectory = new File(this.destinationDirectory, ClassHelper.getPackageName(jc.getClassName()).replace('.', '/'));
                outputDirectory.mkdirs();
                instrument.getClassGen().getJavaClass().dump(new File(outputDirectory, String.valueOf(ClassHelper.getBaseName(jc.getClassName())) + ".class"));
            }
            InstrumentationInternal i = (InstrumentationInternal)InstrumentationFactory.getInstance().newInstrumentation(jc.getClassName());
            instrument.getSourceLineNumbers().isEmpty();
            i.setSourceLineNumbers(instrument.getSourceLineNumbers());
            i.setSourceFileName(jc.getSourceFileName());
            i.setSourceLineNumbersByMethod(instrument.getMethodLineNumbers());
            i.setConditionalsByMethod(instrument.getMethodConditionals());
            i.setMethodNamesAndSignatures(instrument.getMethodNamesAndSignatures());
        }
        catch (IOException ex) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new CoverageRuntimeException(ex);
        }
    }

    void addInstrumentation(File fi) {
        if (fi.isDirectory()) {
            File[] contents = fi.listFiles();
            int i = 0;
            while (i < contents.length) {
                this.addInstrumentation(contents[i]);
                ++i;
            }
        }
        if (this.isClass(fi)) {
            this.instrument(fi);
        }
    }

    void addInstrumentation(String arg) {
        if (this.baseDir == null) {
            this.addInstrumentation(new File(arg));
        } else {
            this.addInstrumentation(new File(this.baseDir, arg));
        }
    }

    void addInstrumentation(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                this.destinationDirectory = new File(args[++i]);
            } else if (args[i].equals("-basedir")) {
                this.baseDir = new File(args[++i]);
            } else if (args[i].equals("-ignore")) {
                this.ignoreRegex = args[++i];
            } else {
                this.addInstrumentation(args[i]);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Instrument instrument = new Instrument();
        instrument.addInstrumentation(args);
    }
}

